/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.zb;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.gprinter.zb.Base64;
import com.gprinter.zb.DitheredImageProvider;
import com.gprinter.zb.ZebraImageInternal;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ZebraImageAndroid
implements ZebraImageInternal {
    private Bitmap bitmap;

    public ZebraImageAndroid(Bitmap bitmap) {
        if (null == bitmap) {
            throw new IllegalArgumentException("bitmap arg cannot be null");
        }
        this.bitmap = bitmap;
    }

    public ZebraImageAndroid(String var1) throws IOException {
        if (null == var1) {
            throw new IllegalArgumentException("image path arg cannot be null");
        }
        this.bitmap = BitmapFactory.decodeFile((String)var1);
        if (null == this.bitmap) {
            throw new IOException("unknown image type");
        }
    }

    public ZebraImageAndroid(InputStream var1) throws IOException {
        this.bitmap = BitmapFactory.decodeStream((InputStream)var1);
        if (null == this.bitmap) {
            throw new IOException("unknown image type");
        }
    }

    @Override
    public int[] getRow(int var1) {
        if (var1 >= this.bitmap.getHeight()) {
            return null;
        }
        int var2 = this.bitmap.getWidth();
        int[] var3 = new int[var2];
        this.bitmap.getPixels(var3, 0, var2, 0, var1, var2, 1);
        return var3;
    }

    @Override
    public int getHeight() {
        return this.bitmap.getHeight();
    }

    @Override
    public int getWidth() {
        return this.bitmap.getWidth();
    }

    @Override
    public boolean scaleImage(int var1, int var2) {
        if (var1 > 0 && var2 > 0) {
            this.bitmap = Bitmap.createScaledBitmap((Bitmap)this.bitmap, (int)var1, (int)var2, (boolean)true);
            return true;
        }
        return false;
    }

    @Override
    public byte[] getDitheredB64EncodedPng() throws IOException {
        ByteArrayOutputStream var1 = new ByteArrayOutputStream();
        this.writeDitheredPng(var1);
        return Base64.encodeBytes(var1.toByteArray(), 8).getBytes();
    }

    @Override
    public void writeDitheredPng(OutputStream var1) throws IOException {
        ByteArrayOutputStream var2 = new ByteArrayOutputStream();
        DitheredImageProvider.getDitheredImage(this, var2);
        int var3 = this.getWidth() / 8 + (this.getWidth() % 8 == 0 ? 0 : 1);
        Bitmap var4 = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
        this.removePixelPaddingFromRaster(this.getWidth(), this.getHeight(), var2, var4, var3);
        var4.compress(Bitmap.CompressFormat.PNG, 100, var1);
    }

    private void removePixelPaddingFromRaster(int var1, int var2, ByteArrayOutputStream var3, Bitmap var4, int var5) {
        byte[] var6 = var3.toByteArray();
        boolean var7 = false;
        for (int var8 = 0; var8 < var2; ++var8) {
            for (int var9 = 0; var9 < var1; ++var9) {
                byte var10 = var6[var8 * var5 + var9 / 8];
                var10 = (byte)((var10 & 1 << 7 - var9 % 8) != 0 ? 1 : 0);
                var4.setPixel(var9, var8, var10 == 0 ? -16777216 : -1);
            }
        }
    }
}

